/*
 * Decompiled with CFR 0.152.
 */
package panther.program;

import java.io.File;
import java.io.FileInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import panther.program.AbstractScore;
import pse.assessment.PantherForm;
import pse.assessment.PantherTask;
import pse.common.NetworkConfiguration;
import pse.result.CompoundEvidenceIdentification;
import pse.result.CompoundObservable;
import pse.result.IosLog;
import pse.result.PrimaryEvidenceIdentification;
import pse.result.PrimaryObservable;
import pse.result.Result;
import pse.result.Session;
import pse.result.WorkProduct;
import pse.util.general.XmlUtils;

public class MarvelPreprocessor
extends AbstractScore {
    public static void main(String[] stringArray) {
        System.out.println("MarvelPreprocessor - Start");
        try {
            if (stringArray.length == 0) {
                System.out.println("Please specify an output file name as an argument in the command line");
                System.exit(-1);
            }
            Result result = new Result();
            Document document = XmlUtils.parse(new FileInputStream(new File("PSEGradeRequest.xml")));
            Node node = XmlUtils.getChildNamed(document, "pse-grade-request");
            Node node2 = XmlUtils.getChildNamed(node, "panther-task");
            MarvelPreprocessor marvelPreprocessor = new MarvelPreprocessor();
            PantherTask pantherTask = new PantherTask();
            pantherTask.fromMyNode(node2);
            PantherForm pantherForm = marvelPreprocessor.createDefaultForm(pantherTask);
            Session session = marvelPreprocessor.createDefaultSession(pantherForm, pantherTask, null);
            marvelPreprocessor.extractResult(session, node2);
            marvelPreprocessor.writeResult(new File(stringArray[0]), result);
        }
        catch (Exception exception) {
            System.out.println("MarvelProcessor " + exception.getMessage());
        }
        System.out.println("MarvelPreprocessor - End");
    }

    public Result extractResult(Session session, Node node) throws Exception {
        Result result = new Result();
        result.setSession(session);
        Node node2 = XmlUtils.getChildNamed(node, "task-metadata");
        Node node3 = XmlUtils.getChildNamed(node2, "pka-info");
        Node node4 = XmlUtils.getChildNamed(node3, "initial-network");
        Node node5 = XmlUtils.getChildNamed(node4, "network-configuration");
        WorkProduct workProduct = result.getOrCreateWorkProduct();
        this.extractWorkProduct(workProduct, node5);
        Node node6 = XmlUtils.getChildNamed(node, "observables");
        Node node7 = XmlUtils.getChildNamed(node6, "primaries");
        PrimaryEvidenceIdentification primaryEvidenceIdentification = result.getOrCreatePrimaryEvidenceIdentification();
        this.extractPrimaryEvidendence(primaryEvidenceIdentification, node7);
        Node node8 = XmlUtils.getChildNamed(node6, "compounds");
        CompoundEvidenceIdentification compoundEvidenceIdentification = result.getOrCreateCompoundEvidenceIdentification();
        this.extractCompoundEvidence(compoundEvidenceIdentification, node8);
        return result;
    }

    private void extractWorkProduct(WorkProduct workProduct, Node node) {
        NetworkConfiguration networkConfiguration = new NetworkConfiguration();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = XmlUtils.getAttributeValue(node2, "name");
            String string2 = XmlUtils.getAttributeValue(node2, "type");
            networkConfiguration.addDevice(string, string2);
            Node node3 = XmlUtils.getChildNamed(node2, "device-info");
            String string3 = XmlUtils.getAttribute(node3, "command");
            String string4 = XmlUtils.getTransitiveText(node3);
            networkConfiguration.addConfiguration(string, string3, string4);
        }
        workProduct.setNetworkConfiguration(networkConfiguration);
        workProduct.setIosLog(new IosLog());
    }

    private void extractPrimaryEvidendence(PrimaryEvidenceIdentification primaryEvidenceIdentification, Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = XmlUtils.getAttribute(node2, "panther-ident");
            PrimaryObservable primaryObservable = new PrimaryObservable();
            primaryObservable.setPantherIdent(string);
            primaryObservable.setCorrect(Boolean.FALSE);
            primaryEvidenceIdentification.addPrimaryObservable(primaryObservable);
        }
    }

    private void extractCompoundEvidence(CompoundEvidenceIdentification compoundEvidenceIdentification, Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = XmlUtils.getAttribute(node2, "panther-ident");
            CompoundObservable compoundObservable = new CompoundObservable();
            compoundObservable.setPantherIdent(string);
            String string2 = XmlUtils.getAttribute(node2, "maximum-points");
            int n2 = string2 == null ? null : Integer.valueOf(new Integer(string2));
            compoundObservable.setPossiblePoints(n2);
            compoundObservable.setEarnedPoints(0);
            compoundEvidenceIdentification.addCompoundObservable(compoundObservable);
        }
    }
}

